;------------------------------------------------------------------------
; Commands file
;------------------------------------------------------------------------

;------------------------------------------------------------------------
; Auto line numbering
; Increment is done once line is accepted
;------------------------------------------------------------------------

AUTONUM         BIT     AUTO_FLAG       Is auto line number enabled?
                BPL     .RTS            Nope!
                LDA     AUTO            Setup next line number
                STA     HEXVAL
                LDA     AUTO+1
                STA     HEXVAL+1
                JSR     PRDECI          Print decimal value
                JSR     PRSPACE         Followed by a space
                STA     IN,X
                INX
.RTS            RTS

;------------------------------------------------------------------------
; Parse command or line number
; A holds the command character
;------------------------------------------------------------------------

COMMAND         LDY     #0              Find command in table
                STY     ERROR           Clear error
                STA     CMD_CHR
.LOOP           LDA     .TABLE,Y
                BEQ     .SYNERR         End of table! Syntax error
                CMP     CMD_CHR         Is it this command
                BEQ     .FOUND          Found our command!
                INY                     Next command from table
                BNE     .LOOP           Always taken!

.FOUND          JSR     IN_BLANK        Get next and see if it's blank
                BNE     .FOUND          A CR would have been too!

                TYA                     Point to command handler's
                ASL                      address in table
                TAY
                INY                     MSB first
                LDA     .JMPS,Y         Get the address and use it
                PHA                      as return address
                DEY
                LDA     .JMPS,Y
                PHA
                LDY     #0              Some commands may benefit from this
                JMP     NNONSPC         Find next non space and exec cmd

.SYNERR         LDA     #ERR_SYN        Exit with syntax error
                STA     ERROR
                RTS

.TABLE          .DA     #"A"            Auto line numbering
                .DA     #"C"            Copy command
                .DA     #"D"            Delete command
                .DA     #"H"            Help command
                .DA     #"L"            List command
                .DA     #"M"            Memory command
                .DA     #"N"            New command
                .DA     #"O"            Old command
                .DA     #"R"            Renumber command
                .DA     #"S"            Start assembling
                .DA     #"V"            Value command
                .DA     #"W"            Woz monitor command
                .DA     #"X"            eXecute command
                .DA     #0              End of table

.JMPS           .DA     CMD_AUT-1       Auto line numbering
                .DA     CMD_COP-1       Copy command
                .DA     CMD_DEL-1       Delete command
                .DA     CMD_HLP-1       Help command
                .DA     CMD_LST-1       List command
                .DA     CMD_MEM-1       Memory command
                .DA     CMD_NEW-1       New command
                .DA     CMD_OLD-1       Old command
                .DA     CMD_REN-1       Renumber command
                .DA     CMD_ASM-1       Start assembling
                .DA     CMD_VAL-1       Value command
                .DA     WOZMON-1        Back to WOZ monitor
                .DA     CMD_XEC-1       eXecute command

;------------------------------------------------------------------------
; Auto command
;------------------------------------------------------------------------

CMD_AUT         BEQ     .SET            Nope!
                CMP     #","            Is line number given?
                BEQ     .INC            Nope!
                JSR     GET_VAL         Get the line number value
                BNE     .RTS            An error occurred!
                STY     AUTO            Save new value
                STA     AUTO+1
                LDA     IN,X            Does the increment follow?
                CMP     #","
                BNE     .SET            Nope!

.INC            INX
                JSR     GET_VAL         Get the increment value
                BNE     .RTS            An error occurred!
                CPY     #0              Inc of 0 not allowed
                BNE     .NOT0           It is not 0!
                INY                     Zero was not allowed
.NOT0           STY     AUTO_INC        Save increment

.SET            DEC     AUTO_FLAG       Make b7=1 (It was 0 before!)
.RTS            RTS

;------------------------------------------------------------------------
; Copy command
;------------------------------------------------------------------------

CMD_COP         STY     UNDEF           Clear undefined label flag
                JSR     .GETVAL         Get Source
                BEQ     ERROR_MISSING   Missing parameter!
                STY     SRCE
                LDA     HEXVAL+1
                STA     SRCE+1
                JSR     .GETVAL         Get Destination
                BEQ     ERROR_MISSING   Missing parameter!
                STY     DEST
                LDA     HEXVAL+1
                STA     DEST+1
                JSR     .GETVAL         Get length
                STY     LENG
                LDA     HEXVAL+1
                STA     LENG+1
                ORA     LENG
                BEQ     .RTS            Length is 0! We're done

                LDA     SRCE            Copy up or down?
                CMP     DEST
                LDA     SRCE+1
                SBC     DEST+1
                BCC     .MOVEUP         Move up!
                JMP     MOV_DOWN        Move memory block down

.MOVEUP         JMP     MOV_UP          Move memory block up

.GETVAL         JSR     NNONSPC         See if end of line
                BEQ     .MIS            Yes!
                JSR     GET_EXPRES      Get value
                BNE     .ERROR          An error occurred
                LDA     UNDEF           Undefined label used?
                BNE     .UNDEF          Yes!
                LDA     IN,X
                CMP     #CR             End of line?
                BEQ     .RTS            Yes! Z=1 now!
                CMP     #","            Must be a comma now
                BNE     .MIS            It's not!
                INX                     Z=0 now!
.RTS            RTS

.MIS            LDA     #ERR_MIS        Exit with missing error
                BNE     .SKIP           Always taken

.UNDEF          LDA     #ERR_DEF        Exit with undefined label
.SKIP           STA     ERROR
.ERROR          PLA                     Pull return address from stack
                PLA
                RTS

;------------------------------------------------------------------------
; DEL command
;------------------------------------------------------------------------

CMD_DEL         JSR     BEG_END         Get begin and end line parameters
                BCS     DELETE          Parameters given! Do delete

ERROR_MISSING   LDA     #ERR_MIS        Exit with missing parameter
                STA     ERROR
DEL_RTS         RTS

;------------------------------------------------------------------------
; Delete block of lines
;------------------------------------------------------------------------

DELETE          LDA     PARM2           Don't delete anything if
                CMP     PARM1            begin > end
                LDA     PARM2+1
                SBC     PARM1+1
                BCC     DEL_RTS         Begin is indeed > end!

                LDY     #PARM1          Find this line number
                JSR     FIND_LINE
                BCC     DEL_RTS         EOF reached! Line not found

                LDA     PNTR            Current pointer is going to be
                STA     DEST             the move's destination anyway
                LDA     PNTR+1
                STA     DEST+1

.LOOP           LDY     #1              See if we're already past end
                LDA     PARM2
                CMP     (PNTR),Y
                INY
                LDA     PARM2+1
                SBC     (PNTR),Y
                BCC     .FOUNDEND       Yes!
                JSR     NEXT_LINE       Find next line
                BNE     .LOOP           Do until end line found!

.FOUNDEND       LDA     PNTR            This pointer is going to be
                STA     SRCE             the source
                EOR     DEST            And see if source and dest are
                STA     COUNT            the same
                LDA     PNTR+1
                STA     SRCE+1
                EOR     DEST+1
                ORA     COUNT
                BEQ     DEL_RTS         They are the same! Why bother

                JSR     CALC_LENG       Calculate number of bytes to move

                JMP     MOV_DOWN        Move from next line to end down

;------------------------------------------------------------------------
; Get begin and end line number from user
;------------------------------------------------------------------------

BEG_END         STY     DUMP            Disable dump mode
                STY     PARM1           Set default begin and end lines
                STY     PARM1+1          Y=0
                DEY
                STY     PARM2
                STY     PARM2+1
                JSR     NNONSPC         Are there any parameters?
                BEQ     .NOPARM         No parameters given!
                CMP     #"D"            Dump mode?
                BEQ     .DUMP           Yes!

                CMP     #","            Is begin line given?
                BEQ     .ENDLIN         Nope!
                JSR     GET_VAL         Get begin line number
                BNE     .ERROR          An error occurred
                STY     PARM1           Save begin line number
                STA     PARM1+1

                LDA     IN,X            Does the end line number follow?
                CMP     #","
                BEQ     .ENDLIN         Yes! Get it
                LDA     HEXVAL+1        If not make begin = end
.SAVE_DONE      STA     PARM2+1
                STY     PARM2
.DONE           SEC                     Indicate parameter given
                RTS

.ENDLIN         JSR     IN_BLANK        Get next and see if it's blank
                BEQ     .DONE           EOL! No line number
                JSR     GET_VAL
                BEQ     .SAVE_DONE      No error occurred

.ERROR          PLA                     An error occurred, pop return
                PLA                      address from stack
                RTS

.DUMP           STA     DUMP            Activate dump mode and CY=0
.NOPARM         CLC                     Indicate no parameters are given
                RTS                      (DEL requires them!)

;------------------------------------------------------------------------
; LIST command
;------------------------------------------------------------------------

CMD_LST         JSR     BEG_END         Get begin and end line parameters

                LDY     #PARM1          Find first line
                JSR     FIND_LINE

.LOOP           JSR     HALT            Halt if key pressed
                BEQ     .RTS            ESC pressed!
                LDY     #0              Check EOF
                LDA     (PNTR),Y
                BEQ     .RTS            Yes!
                INY                     See if we're past end line
                SEC
                LDA     (PNTR),Y
                STA     HEXVAL
                SBC     PARM2
                STA     DELIM           Used to see if equal
                INY
                LDA     (PNTR),Y
                STA     HEXVAL+1
                SBC     PARM2+1
                ORA     DELIM
                BEQ     .EQUAL          Hey, last line to list!
                BCS     .RTS            We're done!

.EQUAL          LDA     DUMP            Dump mode?
                BNE     .SKIP           Yes! Skip line number printing
                JSR     PRDECI
                JSR     PRSPACE

.SKIP           JSR     UNPACK          Unpack current line
                LDX     #0              Print the entire unpacked line
.PRINT          LDA     IN,X
                INX
                JSR     ECHO
                CMP     #CR             End of line?
                BNE     .PRINT          Not yet!
                JSR     NEXT_LINE       Set pointer to next line
                BNE     .LOOP           Repeat if not EOF!

.RTS            RTS

;------------------------------------------------------------------------
; MEMORY command
; Warning! Range is not checked! It's your own responsibility to set the
; range. Illegal ranges are belowe $0200, above RAM, inside own source,
; lomem => himem.
;------------------------------------------------------------------------

CMD_MEM         BEQ     .SHOW           Yes! Set Lomem,Himem

                LDA     IN,X            Is lomem given?
                CMP     #","
                BEQ     .HIMEM          Nope!

                JSR     GET_VAL         Get lomem value
                BNE     RTS_MEM         An error occurred!
                STY     LOMEM           Copy new lomem value
                STA     LOMEM+1

                LDA     IN,X            Is highmem given? (soft)
                CMP     #","
                BNE     .DONE           Nope! Leave it

.HIMEM          INX
                JSR     GET_VAL         Get himem value
                BNE     RTS_MEM         An error occurred!
                STY     HIMEM           Copy new himem value
                STA     HIMEM+1

.DONE           LDY     #0              Perform a new command
                STY     OLD_SAVE        However OLD will not work now
                JSR     DONEW           Clear source program

.SHOW           LDA     LOMEM+1         Print lomem
                LDY     LOMEM
                JSR     PRWORD
                JSR     PRDOT
                LDA     HIMEM+1         And himem
                LDY     HIMEM
                JSR     .PRWORDCR

                JSR     FIND_EOFZ       Find end of source file
                LDY     PNTR
                LDA     PNTR+1
.PRWORDCR       JSR     PRWORD
                JMP     CROUT

;------------------------------------------------------------------------
; NEW command
;------------------------------------------------------------------------

CMD_NEW         LDA     (LOMEM),Y       Save first byte of program (OLD)
                BEQ     RTS_MEM         But don't do it if already 0!
                STA     OLD_SAVE

DONEW           TYA                     Make A=0
                STA     (LOMEM),Y       Clear first byte of program
                STA     SYM_TABLE+1     Invalidate symbol table

                LDA     #DEF_AUTO       Set default AUTO line number
                STA     AUTO
                LDA     /DEF_AUTO
                STA     AUTO+1
                LDA     #DEF_INC        Set default AUTO increment
                STA     AUTO_INC

RTS_MEM         RTS

;------------------------------------------------------------------------
; OLD command
;------------------------------------------------------------------------

                .DO     PROCESSOR=$6502
CMD_OLD         LDA     OLD_SAVE        Is it possible to do OLD?
                BEQ     .ERROR          OLD not possible!
                STA     (LOMEM),Y       Save old value into program
                STY     OLD_SAVE        Clear old flag
                RTS

.ERROR          LDA     #ERR_OLD        OLD error
                STA     ERROR
                RTS
                .EL                     Save some space by omitting error
CMD_OLD         LDA     OLD_SAVE        Is it possible to do OLD?
                BEQ     .ERROR          OLD not possible!
                STA     (LOMEM),Y       Save old value into program
                STY     OLD_SAVE        Clear old flag
.ERROR          RTS
                .FI

;------------------------------------------------------------------------
; Renumber command
;------------------------------------------------------------------------

CMD_REN         STY     PARM1           Set default values
                STY     PARM1+1         Start renumbering from line 0
                LDA     #DEF_AUTO       Set default renumber start addr.
                STA     PARM2
                LDA     /DEF_AUTO
                STA     PARM2+1
                LDA     #DEF_INC        Set default increment
                STA     LENG

                JSR     NNONSPC         Are there any parameters?
                BEQ     .RENUMBER       No parameters given!
                CMP     #","            Is begin line given?
                BEQ     .STRTLIN        Nope!

                JSR     GET_VAL         Get begin line number
                BNE     .DONE           An error occurred
                STY     PARM1           Save begin line number
                STA     PARM1+1

                LDA     IN,X            Does the start line number follow?
                CMP     #","
                BNE     .RENUMBER       Nope! Get going

.STRTLIN        INX                     Get start line
                JSR     GET_VAL
                BNE     .DONE
                STY     PARM2
                STA     PARM2+1

                LDA     IN,X            Is increment given?
                CMP     #","
                BNE     .RENUMBER       Nope! Get going

                INX
                JSR     GET_VAL         Get increment value
                BNE     .DONE
                CPY     #0              May not be zero!
                BEQ     .RANGE          Exit with range error
                STY     LENG            Save increment

.RENUMBER       LDA     PARM2           See if begin line <= start line
                CMP     PARM1            to avoid double line numbers
                LDA     PARM2+1
                SBC     PARM1+1
                BCC     .RANGE          Nope! Exit with range error

                LDA     PARM2           Copy parm2 to auto number
                STA     AUTO
                LDA     PARM2+1
                STA     AUTO+1
                LDA     LENG            Copy increment to auto_inc
                STA     AUTO_INC

                LDY     #PARM1          Find first line number
                JSR     FIND_LINE
                BCC     .DONE           End of file!
                LDY     #0

.LOOP           INY                     Set new line number
                CLC                      and calculate next number
                LDA     AUTO
                STA     (PNTR),Y
                ADC     AUTO_INC
                STA     AUTO
                INY
                LDA     AUTO+1
                STA     (PNTR),Y
                ADC     #0
                STA     AUTO+1
                JSR     NEXT_LINE       Set pointer to next line
                BNE     .LOOP           Nope!

.DONE           RTS

.RANGE          JMP     RANGE_ERROR     Exit with range error

;------------------------------------------------------------------------
; Value command
;------------------------------------------------------------------------

CMD_VAL         BEQ     .RTS            EOL! Missing operand error!
.LOOP           LDA     #0
                STA     UNDEF           Clear undefined label flag
                JSR     GET_EXPRES      Get value
                BNE     .RTS            An error occurred!
                LDA     UNDEF           Undefined label used?
                BNE     VAL_UNDEF       Yes!

                JSR     PRDECI          Print value in decimal (ABS)
                JSR     PRSPACE

                LDA     HEXVAL+1        Save original value
                PHA
                LDA     HEXVAL
                PHA
                LDA     #"+"            Print same value, but this time
                BIT     HEXVAL+1         it may be negative
                BPL     .POS            It is positive!
                JSR     NEGATE          Make value positive again
                LDA     #"-"
.POS            JSR     ECHO            Print sign
                JSR     PRDECI          Print value
                JSR     PRSPACE

                PLA                     Restore hexval
                TAY
                STA     HEXVAL
                PLA
                STA     HEXVAL+1
                JSR     PRWORD          Print value as hex
                JSR     PRSPACE

                LDA     #"%"            Print percent
                JSR     ECHO
                LDA     HEXVAL+1        Is high byte 0?
                BEQ     .LOW            Yes! Do only the low byte
                JSR     .PRBIN          Print this byte binary
                JSR     PRDOT
.LOW            LDA     HEXVAL          Print low byte in binary too
                JSR     .PRBIN

                JSR     CROUT
                LDA     IN,X            Is next char a comma?
                INX
                CMP     #","
                BEQ     .LOOP           Yes! Then more will follow!
.RTS            RTS                     Ignore rest (soft error check)

.PRBIN          STA     CHAR
                JSR     .PRNIB          Print nibble
                JSR     PRDOT
.PRNIB          LDY     #4              Setup bit counter
.BITLOOP        LDA     #"0"/2          Start with ASCII 0
                ASL     CHAR            Move next bit to CY
                ROL                     Add bit to ASCII
                JSR     ECHO             and print it
                DEY
                BNE     .BITLOOP        Do all 4 bits
VAL_RTS         RTS

VAL_UNDEF       JMP     UNDEF_ERROR     Exit with undefined label used

;------------------------------------------------------------------------
; XEC command
;------------------------------------------------------------------------

CMD_XEC         BEQ     .RUN            Nope! Run from last known addr.

                JSR     GET_EXPRES      Get address to run from
                BNE     VAL_RTS         An error occurred!
                LDX     UNDEF           Undefined label used?
                BNE     VAL_UNDEF       Yep!
                STY     XEC_LAST        Save XEC address
                STA     XEC_LAST+1

.RUN            JSR     .JSRIND         Imitate JSR (IND)
                JMP     CROUT

.JSRIND         JMP     (XEC_LAST)      GO!

;------------------------------------------------------------------------
; XEC command
;------------------------------------------------------------------------

IN_BLANK        INX                     Find end of command in IN
                LDA     IN,X            Get character
                CMP     #" "
                BEQ     .RTS            A space is the end!
                CMP     #CR
.RTS            RTS
