;------------------------------------------------------------------------
; Add line to the program
;------------------------------------------------------------------------

ADDLINE         JSR     GET_VAL         Get line number
                BEQ     .NOERR          No error occurred!
                RTS

.NOERR          CLC
                LDA     HEXVAL          Calculate next auto line number
                ADC     AUTO_INC
                STA     AUTO
                LDA     #0              Invalidate symbol table
                STA     SYM_TABLE+1
                STA     OLD_SAVE        Invalidate OLD command
                ADC     HEXVAL+1        Oh yes, we were busy adding
                STA     AUTO+1           something!

                TXA                     Save read index
                TAY
                JSR     NNONSPC         See if line contains text
                BNE     .OK             It does!
                LDA     HEXVAL          Set begin and end line to linenum
                STA     PARM1            to delete this line from source
                STA     PARM2
                LDA     HEXVAL+1
                STA     PARM1+1
                STA     PARM2+1
                JMP     DELETE          Delete this line!

.OK             TYA                     Restore read index
                TAX
                LDY     #0              Clear write index
                LDA     IN,X            Ignore first space after linenum
                CMP     #" "             (not part of source)
                BNE     .LOOP1          Forget about 1st space!

.LOOP           INX                     Get next character
.LOOP1          LDA     IN,X
                CMP     #" "            Is it a space?
                BEQ     .PACK           Yes! Pack it!
                CMP     #"-"            Is it a dash?
                BEQ     .PACK           Yes! Pack it!
                CMP     #CR             Is it end of line?
                BEQ     .EOL            Yes! Packed entire line now!
.WRITE          STA     IN,Y            Save normal character
                INY                     Increment write pointer
                BNE     .LOOP           Always taken!

.PACK           STA     DELIM           Save character to pack
                LDA     #1              Init repetition counter
                STA     COUNT
.PCKLOOP        INX                     Count number of same characters
                LDA     IN,X
                CMP     DELIM
                BNE     .PCKEXIT        It's not the same anymore!
                INC     COUNT           Increment counter
                LDA     COUNT           Don't allow it to exceed 63
                CMP     #63
                BCC     .PCKLOOP        Still OK!
                INX                     Compensate for normal exit

.PCKEXIT        DEX                     We're too far now
                LDA     DELIM           Was it space or dash?
                EOR     #" "              (Makes A=0 if it is space
                BEQ     .SPACE          It was space!
                LDA     #%0100.0000     Set dash flag
.SPACE          ORA     COUNT           Combine with counter
                BNE     .WRITE          Always taken!

.EOL            TYA                     Add 3 byte overhead to length
                CLC
                ADC     #3
                STA     LENG            Save length
                STA     COUNT
                LDY     #HEXVAL         Find line in program memory
                JSR     FIND_LINE
                BCC     .NEWLINE        EOF! Line does not exist yet
                BNE     .NEWLINE        Line does not exist yet

; The line number already exists. Compare both line lengths

                LDY     #0              Is new line longer or shorter?
                SEC
                LDA     LENG
                SBC     (PNTR),Y
                BEQ     .INSERT         Line length did not change!
                STA     LENG            Save number of bytes difference
                BCS     .NEWLINE        Make room for longer line

.SHORTER        SEC                     Setup source and destination to
                LDA     PNTR             move the source down
                PHA
                STA     DEST
                SBC     LENG            (length is negative!)
                STA     SRCE
                LDA     PNTR+1
                PHA
                STA     DEST+1
                SBC     #-1             (keep high byte negative too!)
                STA     SRCE+1
                JSR     CALC_LENG       Get the number of bytes to move
                PLA                     Restore PNTR (was destroyed by
                STA     PNTR+1           CALC_LENG)
                PLA
                STA     PNTR
                JSR     MOV_DOWN        Move rest of program down
                JMP     .INSERT         Insert new, shorter, line

.NEWLINE        LDA     PNTR            Use current pointer as
                PHA                      source
                STA     SRCE
                CLC                     Add new line's length to it
                ADC     LENG             to find the destination
                STA     DEST
                LDA     PNTR+1
                PHA
                STA     SRCE+1
                ADC     #0
                STA     DEST+1
                JSR     CALC_LENG       Calculate number of bytes to move

                CLC                     See if there's enough room in
                LDA     DEST             memory until HIMEM
                ADC     LENG
                STA     PNTR
                LDA     DEST+1
                ADC     LENG+1
                STA     PNTR+1
                LDA     HIMEM
                CMP     PNTR
                LDA     HIMEM+1
                SBC     PNTR+1
                BCC     .MEMFUL         Memory full!

                JSR     MOV_UP          Move them!
                PLA                     Restore pointer
                STA     PNTR+1
                PLA
                STA     PNTR

.INSERT         LDY     #0              Insert new line to freed space
                LDX     #0
                LDA     COUNT           Start with length byte
                STA     (PNTR),Y
                SEC                     Subtract header length
                SBC     #3
                STA     COUNT
                INY
                LDA     HEXVAL          Then comes the line number
                STA     (PNTR),Y
                INY
                LDA     HEXVAL+1
                STA     (PNTR),Y
                INY
.INSLOOP        LDA     IN,X            Get byte from new line
                STA     (PNTR),Y         and store it
                INX
                INY
                DEC     COUNT
                BNE     .INSLOOP        Not all bytes done yet!
                RTS

.MEMFUL         LDA     #ERR_MEM        Exit with memory full error
                STA     ERROR
                PLA                     Clear stack
                PLA
                RTS

;------------------------------------------------------------------------
; Calculate the length of the memory block to be moved
;------------------------------------------------------------------------

CALC_LENG       JSR     FIND_EOF        Find end of source
                SEC                     Calculate number of bytes to
                LDA     PNTR             be moved
                SBC     SRCE
                STA     LENG
                LDA     PNTR+1
                SBC     SRCE+1
                STA     LENG+1
                INC     LENG            Move end byte too!
                BNE     .NOCY
                INC     LENG+1
.NOCY           RTS

;------------------------------------------------------------------------
; Set pointer to begin of file
;------------------------------------------------------------------------

SET_BOF         LDA     LOMEM           Set pointer to begin of program
                STA     PNTR             memory
                LDA     LOMEM+1
                STA     PNTR+1
                RTS

;------------------------------------------------------------------------
; Find end of program memory
;------------------------------------------------------------------------

FIND_EOFZ       JSR     SET_BOF         Set pointer to begin of file
FIND_EOF        LDY     #0              Point to line length
.LOOP           LDA     (PNTR),Y        Get current line's length
                BEQ     .EOF            EOF found!
                CLC                     Add line length to current pntr
                ADC     PNTR
                STA     PNTR
                BCC     .LOOP           Carry is not set!
                INC     PNTR+1
                BCS     .LOOP           Always taken
.EOF            RTS

;------------------------------------------------------------------------
; Find line in program memory
; Line number to search for is located at 0,Y
; EOF -> C=0
; Line found -> C=1 & Z=1
; Line not found, pointing at next higher line -> C=1 & Z=0
;------------------------------------------------------------------------

FIND_LINE       LDA     0,Y             Get line number to find
                STA     HEXVAL
                LDA     1,Y
                STA     HEXVAL+1
                JSR     SET_BOF         Start looking at begin of program
                LDY     #0              Empty program?
                LDA     (PNTR),Y
                BEQ     .EOF            Yes!

.LOOP           INY                     Point to line number
                SEC                     Subtract wanted line from this
                LDA     (PNTR),Y         line number
                SBC     HEXVAL
                STA     DELIM
                INY
                LDA     (PNTR),Y
                SBC     HEXVAL+1
                ORA     DELIM           Z=1 if line is found
                BCS     .QUIT           Found it or past it!
                JSR     NEXT_LINE       Find next line
                BNE     .LOOP           Not end of file yet!
.EOF            CLC                     Indicate EOF
.QUIT           RTS

;------------------------------------------------------------------------
; Set pointer to the next line
;------------------------------------------------------------------------

NEXT_LINE       LDY     #0              Point to line length
                LDA     (PNTR),Y        Add length to pointer
                CLC
                ADC     PNTR
                STA     PNTR
                BCC     .SKIP           No carry!
                INC     PNTR+1
.SKIP           LDA     (PNTR),Y        Set Z if this is EOF
                RTS

;------------------------------------------------------------------------
; Unpack source line to IN (Without line number)
;------------------------------------------------------------------------

UNPACK          LDY     #0              Get line length
                LDA     (PNTR),Y
                SEC
                SBC     #3              Subtract length and line-num
                STA     COUNT
                LDX     #0              Start at IN
                LDY     #3              This is where the fun is

.LOOP           LDA     (PNTR),Y        Get byte from source
                BPL     .UNPACK         It's a packed byte!
                STA     IN,X            It's a normal character
                INX
.NEXT           INY                     Point to next source byte
                DEC     COUNT           Decrement length counter
                BNE     .LOOP           Not done yet!

                LDA     #CR             Terminate unpacked line with CR
                STA     IN,X
                RTS

.UNPACK         PHA                     Save packed type (space or -)
                STY     DELIM           Save source code pointer
                AND     #%0011.1111     Strip away type flag
                TAY                      to keep repeat counter
                PLA                     Find out what type it was
                ASL
                BMI     .DASH           It was a DASH!
                LDA     #" "            Expand a space
                BNE     .EXPAND         Always taken!

.DASH           LDA     #"-"            Expand a dash
.EXPAND         STA     IN,X            Save character to IN
                INX
                DEY                     Decrement counter
                BNE     .EXPAND         Not done yet!
                LDY     DELIM           Restore index in source
                BNE     .NEXT           Always taken!

