'----------------------------------------------------------------------------
'                PC AT-KEYBOARD for A1-REP
'                  (c) 2006 F.X.ACHATZ
'----------------------------------------------------------------------------
'connect PC AT keyboard clock to PIND.2 on the Tiny2313
'connect PC AT keyboard data to PIND.4 on the Tiny2313
'PortB0 - B6 = Data Out
'Portb,7 = STROBE (5ms Keyboard and 1ms via serial)
'Portd.3 = Reset 6502

$regfile = "Attiny2313.dat"

$crystal = 8000000
$baud = 2400

$hwstack = 32
$swstack = 16
$framesize = 32


Config Keyboard = Pind.2 , Data = Pind.4 , Keydata = Keydata
Config Portb = Output

Config Int0 = Falling                                       'generate an interrupt on the falling edge.
On Int0 Isr0
On Urxc Get_ser
Enable Int0
Enable Urxc                                                 ' RxD interrupt flag

Dim A As Byte
Dim B As Byte

Dim Ser_rx As Byte                                          ' ser rx byte
Dim Ser_received_flag As Bit                                ' flag to start routine

Enable Interrupts                                           'Global Interrupt Enable

Waitms 1000                                                 'Keyboardstartuptime

Config Pind.5 = Output
sbi portd,5

B = 0                                                       'Clear eventual garbage generated by the Keyboard during power-up.

Do
   If B > 0 Then
      If B = 18 Then                                        'CRTL-R
      Config Pind.3 = Output
      cbi portd,3
      Waitms 20
      sbi portd,3

      Elseif B = 12 Then                                    'CRTL-L
      Config Pina.0 = Output
      cbi porta,0
      Waitms 20
      sbi porta,0
      B = 0


      Else
      Portb = B
      sbi portb,7
      Waitms 5
      cbi portb,7
      B = 0
      End If
   End If


If Ser_received_flag = 1 Then                               'a byte has been received RS232
   Disable Serial
   If Ser_rx = 18 Then                                      'CRTL-R
   Config Pind.3 = Output
   cbi portd,3
   Waitms 20
   sbi portd,3

   Elseif Ser_rx = 12 Then                                  'CRTL-L
   Config Pina.0 = Output
   cbi porta,0
   Waitms 20
   sbi porta,0

   Elseif Ser_rx > 95 And Ser_rx < 123 Then
   Portb = Ser_rx - 32
   sbi portb,7
   Waitms 1
   cbi portb,7

   Else
   Portb = Ser_rx
   sbi portb,7
   Waitms 1
   cbi portb,7
   End If

   Reset Ser_received_flag                                  'reset the ser rx flag
   Enable Serial
   Ser_rx = 0
End If
Loop
End


'-------- Interrupt routine to fetch serial byte from port--------------
Get_ser:
Ser_rx = Udr
Set Ser_received_flag
Return


Isr0:                                                       'interrupt routine
B = Getatkbd()                                              'Get data from AT keyboard
Set Gifr.intf0                                              'Clear the External Interrupt Flag 0
Return


Keydata:                                                    ''This is the key translation table for the function Getatkbd().

'normal keys lower case
Data 0 , 0 , 0 , 0 , 0 , 12 , 0 , 18 , 0 , 0 , 0 , 0 , 0 , 88 , 0 , 0
Data 0 , 0 , 0 , 0 , 0 , 81 , 49 , 0 , 0 , 0 , 90 , 83 , 65 , 87 , 50 , 0
Data 0 , 67 , 88 , 68 , 69 , 52 , 51 , 0 , 0 , 32 , 86 , 70 , 84 , 82 , 53 , 0
Data 0 , 78 , 66 , 72 , 71 , 89 , 54 , 0 , 0 , 76 , 77 , 74 , 85 , 55 , 56 , 0
Data 0 , 44 , 75 , 73 , 79 , 48 , 57 , 0 , 0 , 46 , 47 , 76 , 59 , 80 , 45 , 0
Data 0 , 0 , 39 , 0 , 91 , 61 , 57 , 0 , 0 , 0 , 13 , 93 , 0 , 92 , 0 , 0
Data 0 , 62 , 0 , 0 , 0 , 8 , 223 , 0 , 49 , 49 , 52 , 52 , 55 , 0 , 0 , 0
Data 48 , 46 , 50 , 53 , 54 , 56 , 27 , 0 , 0 , 43 , 51 , 45 , 42 , 57 , 0 , 0


'shifted keys UPPER case
Data 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0
Data 0 , 0 , 0 , 0 , 0 , 81 , 33 , 0 , 0 , 0 , 90 , 83 , 65 , 87 , 64 , 0
Data 0 , 67 , 88 , 68 , 69 , 36 , 35 , 0 , 0 , 0 , 86 , 70 , 84 , 82 , 37 , 0
Data 0 , 78 , 66 , 72 , 71 , 89 , 94 , 0 , 0 , 0 , 77 , 74 , 85 , 38 , 42 , 0
Data 0 , 60 , 75 , 73 , 79 , 41 , 40 , 0 , 0 , 62 , 63 , 76 , 58 , 80 , 95 , 0
Data 0 , 0 , 34 , 0 , 123 , 43 , 0 , 0 , 0 , 0 , 0 , 125 , 0 , 124 , 0 , 0
Data 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0
Data 0 , 46 , 0 , 0 , 0 , 0 , 4 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0